local super = require "NumberFormatter"

CurrencyFormatter = super:new()

local defaults = {
    decimals = 2,
    groupings = true,
    symbol = '$',
}

local nilDefaults = {
}

function CurrencyFormatter:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    return self
end

function CurrencyFormatter:getFormatter()
    return NumberStringFormatter:currency()
end

function CurrencyFormatter:getArguments()
    return {
        self:getProperty('symbol'),
        self:getProperty('decimals'),
        1,
        self:getProperty('groupings'),
    }
end

function CurrencyFormatter:getInspectors()
    local list = List:new()
    local inspector, hook
    inspector = Inspector:new{
        type = 'Decimal',
    }
    inspector:addHook(self:getPropertyHook('decimals'), 'decimals')
    inspector:addHook(self:getPropertyHook('groupings'), 'groupings')
    list:add(inspector)
    inspector = self:createInspector('string-short', {'symbol'}, 'Symbol')
    list:add(inspector)
    return list
end

return CurrencyFormatter
